(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7527,        278]*)
(*NotebookOutlinePosition[      8396,        306]*)
(*  CellTagsIndexPosition[      8352,        302]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->7,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ FileName], " \[Bullet]  ", 
            ValueBox[ Date]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ FileName], " \[Bullet]  ", 
            ValueBox[ Date]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  DefaultNewCellStyle->"Text",
  DefaultDuplicateCellStyle->"Text",
  DefaultInlineFormatType->StandardForm,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{45, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{47, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output",
  StyleMenuListing->None],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{4, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Printout"],
  ImageSize->{250, 250},
  ImageMargins->{{30, Inherited}, {Inherited, 0}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{12, 10}, {7, 7}},
  LineSpacing->{1, 2},
  FontFamily->"Courier"],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{24, Inherited}, {8, 24}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  CounterIncrements->"Section",
  FontFamily->"Courier",
  FontWeight->"Bold"],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{15, 0}, {7, 22}},
  FontSize->10]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0 Beta 3",
ScreenRectangle->{{0, 1024}, {0, 748}},
CellGrouping->Manual,
WindowSize->{494, 279},
WindowMargins->{{12, Automatic}, {Automatic, 8}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 50, "Section"],
Cell[2034, 63, 77, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 140, 4, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2291, 76, 35, 0, 30, "Section"],
Cell[2329, 78, 101, 3, 30, "Text"],
Cell[2433, 83, 595, 15, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3065, 103, 42, 0, 30, "Section"],
Cell[3110, 105, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[3383, 114, 467, 14, 41, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[3853, 130, 85, 2, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3975, 137, 480, 14, 39, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output",
  StyleMenuListing->None],
Cell[4458, 153, 86, 2, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4581, 160, 501, 14, 36, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[5085, 176, 138, 3, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5260, 184, 498, 14, 36, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[5761, 200, 109, 2, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5907, 207, 439, 12, 36, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[6349, 221, 130, 3, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6516, 229, 128, 4, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[6647, 235, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6826, 245, 34, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[6885, 249, 106, 3, 70, 23, 0, "StyleData", "Text", "All"],
Cell[6994, 254, 83, 2, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7114, 261, 281, 8, 70, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section"],
Cell[7398, 271, 89, 2, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

